<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:strip-space elements="*"/>
    <xsl:variable name="linearUnit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">st</xsl:when>
            <xsl:otherwise>m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit1">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">st2</xsl:when>
            <xsl:otherwise>m2</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit2">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">akr</xsl:when>
            <xsl:otherwise>ha</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads">
                    <xsl:text/>

                    <xsl:text>                        Výpis vytýčení&#xd;</xsl:text>
                    <xsl:text>        Datum výpisu:  </xsl:text>
                    <xsl:value-of select="cif:date()"/>
                    <xsl:text> Čas:  </xsl:text>
                    <xsl:value-of select="cif:time()"/>
                    <xsl:text>&#xd;&#xd;</xsl:text>

                    <xsl:for-each select="GeometryProject">
                        <xsl:text>&#xd;             Projekt:  </xsl:text><xsl:value-of select="@name"/>
                        <xsl:text>&#xd;               Popis:  </xsl:text><xsl:value-of select="@description"/>
                        <xsl:text>&#xd;       Název souboru:  </xsl:text><xsl:value-of select="@file"/>
                        <xsl:text>&#xd;     Poslední revize:  </xsl:text>
                        <xsl:value-of select="@lastRevisedBy"/><xsl:text> </xsl:text>
                        <xsl:value-of select="@lastRevisedDate"/>
                        <xsl:text>  Poznámka:  Všechny jednotky tohoto výpisu jsou</xsl:text>
                        <xsl:choose>
                            <xsl:when test="//@linearUnits = 'Metric'"> v metrech, </xsl:when>
                            <xsl:otherwise> ve stopách, </xsl:otherwise>
                        </xsl:choose>
                        <xsl:text>pokud není specifikováno jinak.&#xd;</xsl:text>

                        <xsl:for-each select="HorizontalAlignment">
                            <xsl:text>&#xd;         Název trasy:  </xsl:text>
                            <xsl:value-of select="@name"/>
                            <xsl:text>&#xd;         Popis trasy:  </xsl:text>
                            <xsl:value-of select="@description"/>
                            <xsl:text>&#xd;&#xd;</xsl:text>
                            <xsl:text>                                           - - S o u ř a d n i c e - -&#xd;</xsl:text>
                            <xsl:text>Bod          Směrník          Vzdálenost    Y                  X&#xd;</xsl:text>
                            <xsl:text>----------   -------------    ----------    -----------        -----------&#xd;</xsl:text>
                            <xsl:apply-templates select="//HorizontalLine | //HorizontalCircle | //HorizontalSpiral"/>
                            <xsl:if test="@northingClosingError">
                                <xsl:text>       Chyba Y:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@northingClosingError), 13)"/>
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="$linearUnit"/>
                                <xsl:text>            Chyba X:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@eastingClosingError), 12)"/>
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="$linearUnit"/>
                                <xsl:text>&#xd; Směr uzavření:  </xsl:text>
                                <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@closingDirection))), 15)"/>
                                <xsl:text>     Délka uzavření:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@closingDistance), 12)"/>
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="$linearUnit"/>
                                <xsl:text>&#xd;      Přesnost:  </xsl:text>
                                <xsl:value-of select="cif:columnDoubleFormat(number(@closingPrecision), 11)"/>
                            </xsl:if>
                            <xsl:text>&#xd;</xsl:text>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="HorizontalLine">
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Start/@name">
                <xsl:value-of select="cif:columnFormat(string(Start/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 44)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 19)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@direction))), 26)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(@length), 11)"/>
        <xsl:text>&#xd;&#xd;</xsl:text>
        <xsl:if test="position() = last()">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)), 3)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <xsl:value-of select="cif:columnFormat(string(End/@name), 4)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 44)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 19)"/>
            <xsl:text>&#xd;&#xd;</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template match="HorizontalCircle">
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Start/@name">
                <xsl:value-of select="cif:columnFormat(string(Start/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 44)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 19)"/>
        <xsl:text>&#xd;&#xd;      Směrník Vstupní tečny:</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@tangentialDirectionStart))), 15)"/>
        <xsl:text>   Směrník Radiální:</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@radialDirectionStart))), 20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Center/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Center/@name">
                <xsl:value-of select="cif:columnFormat(string(Center/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Center/@northing), 44)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Center/@easting), 19)"/>
        <xsl:text>&#xd; Poloměr:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@radius), 9)"/>
        <xsl:text>    Úhel:</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:angularFormat(number(@delta))), 10)"/>
        <xsl:choose>
            <xsl:when test="@rotationDirection = 'ccw'"><xsl:text>  Vlevo</xsl:text></xsl:when>
            <xsl:otherwise><xsl:text> Vpravo</xsl:text></xsl:otherwise>
        </xsl:choose>
        <xsl:text>  Délka:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@length), 8)"/>
        <xsl:text>&#xd;   Tečna:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@tangentLength), 9)"/>
        <xsl:text>  Tětiva:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@chord), 8)"/>
        <xsl:text>&#xd;       Směrník Radiální:</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@radialDirectionEnd))), 18)"/>
        <xsl:text>   Směrník Výstupní tečny:</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@tangentialDirectionEnd))), 15)"/>
        <xsl:text>&#xd;&#xd;</xsl:text>
        <xsl:if test="position() = last()">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)), 3)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <xsl:value-of select="cif:columnFormat(string(End/@name), 4)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 44)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 19)"/>
            <xsl:text>&#xd;&#xd;</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template match="HorizontalSpiral">
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)), 3)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Start/@name">
                <xsl:value-of select="cif:columnFormat(string(Start/@name), 4)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 44)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 19)"/>
        <xsl:text>&#xd;&#xd;</xsl:text>
        <xsl:if test="position() = last()">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)), 3)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <xsl:value-of select="cif:columnFormat(string(End/@name), 4)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('  ', '  ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 44)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 19)"/>
            <xsl:text>&#xd;&#xd;</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
         <xsl:text>Pro tento výpis musíte vybrat&#xd;</xsl:text>
        <xsl:text>  nejméně jeden Civil prvek směrové geometrie.&#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2012 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
